/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: attrib.c,v 1.14 2005/06/29 00:23:16 eugene Exp $";

#include <stdlib.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "attrib.h"

void
mx_destroy_attribute(struct mx_attr *ap)
{
  if (ap->value != NULL) {
    free(ap->value);
  }
  free(ap);
}

void
mx_free_attr_list(struct mx_endpoint *pp)
{
  struct mx_attr *ap, *nap;

  ap = pp->attr_list;
  while (ap != NULL) {
    nap = ap->next;
    mx_destroy_attribute(ap);
    ap = nap;
  }

  pp->attr_list = NULL;
}

struct mx_attr *
mx_new_attribute(char *name,
                 void *value,
                 uint32_t len)
{
  struct mx_attr *ap;

  ap = (struct mx_attr *)calloc(1, sizeof (*ap));
  if (ap == NULL) {
    return NULL;
  }

  ap->value = (void *)malloc(len);
  if (ap->value == NULL) {
    free(ap);
    return NULL;
  }

  /* fill in values */
  ap->name = name;
  memcpy(ap->value, value, len);
  ap->len = len;

  /* return newly created attribute struct */
  return ap;
}

mx_return_t
mx_create_attribute(struct mx_endpoint *pp,
                    char *name,
                    void *value,
                    uint32_t len)
{
  struct mx_attr *ap;

  ap = mx_new_attribute(name, value, len);
  if (ap == NULL) {
    return MX_NO_RESOURCES;
  }

  /* successfully built attribute, link into endpoint list */
  ap->next = pp->attr_list;
  pp->attr_list = ap;

  return MX_SUCCESS;
}

mx_return_t
mx_set_dflt_endpoint_attribs(struct mx_endpoint *pp)
{
  mx_return_t rc;
  uint32_t intval;

  rc = mx_create_attribute(pp,
                           "my_address",
                           &pp->my_address,
			   sizeof (pp->my_address));
  if (rc != MX_SUCCESS) {
    return rc;
  }

  intval = 0;
  rc = mx_create_attribute(pp,
                           "board_number",
                           &intval,
			   sizeof (intval));
  if (rc != MX_SUCCESS) {
    return rc;
  }

  return MX_SUCCESS;
}
